/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.fw.fcs.chatlet;

import com.ibm.hwmca.fw.fcs.chatlet.ChatletResponse;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;

public class ChatletErrorResponse
extends ChatletResponse {
    short specificErrorCode = 0;
    String errorMessage = "";

    protected static String specificErrorToString(short type) {
        switch (type) {
            case 0: {
                return "generic";
            }
            case 1: {
                return "ClassNotFound";
            }
            case 2: {
                return "Instantiation";
            }
            case 3: {
                return "IllegalAccess";
            }
            case 4: {
                return "NamedNotChatlet";
            }
            case 5: {
                return "IdentifierNotFound";
            }
            case 6: {
                return "RequestTypeUnknown";
            }
            case 7: {
                return "ExceptionDrivingRequestMethod";
            }
            case 8: {
                return "UnableToLocateTerminateTarget";
            }
        }
        return "unknown";
    }

    public ChatletErrorResponse() {
        this(0);
    }

    public ChatletErrorResponse(short specificErrorCode) {
        this.requestType = 1;
        this.requestSubType = (short)2;
        this.specificErrorCode = specificErrorCode;
    }

    protected void writeToStream(ObjectOutputStream oos) throws IOException {
        super.writeToStream(oos);
        oos.writeShort(this.specificErrorCode);
        oos.writeUTF(this.errorMessage);
    }

    public short getSpecificErrorCode() {
        return this.specificErrorCode;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    void load(DataInputStream in) throws IOException {
        this.specificErrorCode = in.readShort();
        this.errorMessage = in.readUTF();
    }

    public String toString() {
        return "ChatletPacket[" + this.transactionId + "," + this.chatletId + "," + ChatletErrorResponse.typeToString(this.requestType) + "," + ChatletErrorResponse.subtypeToString(this.requestSubType) + "," + ChatletErrorResponse.specificErrorToString(this.specificErrorCode) + "," + Integer.toHexString(this.hashCode()) + "]";
    }
}

